<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

/*
 * Penda Project
 *
 * @developer	        I-Rock Technologies Limited
 * @copyright	        Copyright (c) 2014 - 2024 Penda
 * @project link		https://penda.irock.co.zm
 * @developer link      https://www.irock.co.zm
 */

/**
 * Class Mdl_expenses
 */
class Mdl_bills extends Response_Model
{
    public $table = 'pd_bills';
    public $primary_key = 'pd_bills.bill_id';

    public function default_select()
    {
        $this->db->select('SQL_CALC_FOUND_ROWS *', false);
    }

    public function default_order_by()
    {
        $this->db->order_by('pd_vendors.vendor_name, pd_bills.bill_name');
    }

    public function default_join()
    {
        $this->db->join('pd_vendors', 'pd_vendors.vendor_id = pd_bills.bill_category', 'left');

    }

    public function statuses()
    {
        return array(
            '1' => array(
                'label' => trans('draft'),
                'class' => 'draft',
                'href' => 'expense/status/draft'
            ),
            '2' => array(
                'label' => trans('sent'),
                'class' => 'sent',
                'href' => 'expense/status/sent'
            ),
            '3' => array(
                'label' => trans('viewed'),
                'class' => 'viewed',
                'href' => 'expense/status/viewed'
            ),
            '4' => array(
                'label' => trans('paid'),
                'class' => 'paid',
                'href' => 'expense/status/paid'
            )
        );
    }


    public function by_bill($match)
    {
        $this->db->group_start();
        $this->db->like('pd_bills.bill_name', $match);
        $this->db->or_like('pd_bills.bill_description', $match);
        $this->db->or_like('pd_bills.bill_vendor', $match);
        $this->db->group_end();
    }

    public function by_vendor($match)
    {
        $this->db->where('pd_bills.bill_category', $match);
    }

    /**
     * @return array
     */
    public function validation_rules()
    {
        return array(

            'bill_name' => array(
                'field' => 'bill_name',
                'label' => trans('expense_name'),
                'rules' => 'required'
            ),
            'bill_description' => array(
                'field' => 'bill_description',
                'label' => trans('expense_description'),
                'rules' => ''
            ),
            'bill_amount' => array(
                'field' => 'bill_amount',
                'label' => trans('expense_amount'),
                'rules' => 'required'
            ),

            'bill_vendor' => array(
                'field' => 'bill_vendor',
                'label' => trans('expense_vendor'),
                'rules' => ''
            ),
            'bill_category' => array(
                'field' => 'bill_category',
                'label' => trans('expense_category'),
                'rules' => 'numeric'
            ),
            'bill_date' => array(
                'field' => 'bill_date',
                'label' => trans('expense_date'),
                'rules' => ''
            ),

        );
    }

    /**
     * @return array
     */
    public function db_array()
    {
        $db_array = parent::db_array();

        $db_array['bill_amount'] = (empty($db_array['bill_amount']) ? null : standardize_amount($db_array['bill_amount']));
        $db_array['bill_category'] = (empty($db_array['bill_category']) ? null : $db_array['bill_category']);

        return $db_array;
    }

    public function is_sumex()
    {
        $this->where('sumex_id is NOT NULL', null, false);
        return $this;
    }


}
